import ProjectDetailsPage from "@/component/template/ProjectDetails/ProjectDetailsPage";
import OtherProjects from "@/component/template/ProjectDetails/OtherProjects";
import fetchData from '@/FetchData';

const ProjectDetails = ({ projectsData, allProjects, id }: any) => {
  return (
    <div className="mt-[100px]">
      <ProjectDetailsPage data={projectsData.result.data} />
      <OtherProjects projects={allProjects.result.data} currentProjectId={id} />
    </div>
  );
};

export default ProjectDetails;

export async function getServerSideProps(context: any) {
  const { id } = context.query;
  if (!id) {
    return {
      notFound: true,
    };
  }

  const { req } = context;
  const keyValuePairs = req?.headers?.cookie?.split(";");
  const languagePair = keyValuePairs?.find((pair: any) =>
    pair.includes("i18next")
  );
  const language = languagePair ? languagePair.split("=")[1] : "ar";
  
  const allProjects = await fetchData("user/projects", language);
  const projectsData = await fetchData(`user/projects/${id}`, language);

  return {
    props: {
      projectsData,
      allProjects,
      id,
    },
  };
}